---
name: managing-spec-document
description: Manage spec.md documents for Spec-Driven Development (SDD). Handles creating, updating, deleting, and retrieving spec.md files while enforcing "what to build" constraints (excludes design details). Trigger when working with SDD spec.md file and after creating-sdd-directory skill.
---

# managing spec document
## Purpose
This Skill manages `spec.md` documents for Spec-Driven Development (SDD) based on `spec_template.md` standards. It ensures consistent creating, updating, deleting, and retrieving of requirement-focused spec files while strictly separating "what to build" (Spec) from "how to build it" (Design).

## Prerequisites
Project directory structure of spec.md :
```
.codeartsdoer/
└── specs/
    └──{{feature-name}}/
        └── spec.md
```

## Core Capabilities
### 1. Create Spec Files
Must follow these rules step-by-step to generate new `spec.md` files:
- Check if `.codeartsdoer/specs/{{feature-name}}//spec.md` exist
- If missing: Combine the user's requirements with the structure/requirements from `spec_template.md` to generate the `/.codeartsdoer/specs/{{feature-name}}//spec.md`  file. Note: The `.codeartsdoer/specs/{{feature-name}}//spec.md` format must be strictly followed `spec_template.md` .
- Include mandatory sections from the template (e.g., Purpose, Requirements, Scenarios) and populate content aligned with user needs
- Do **not** modify existing feature-specific spec.md if it already exists

### 2. Update Spec Files
Must follow these rules step-by-step to update `spec.md` files:
- All requirement modifications (additions, edits, removals) are written **only** to `.codeartsdoer/specs/{{feature-name}}/spec.md`
- Clear spec.md file and write user-edited spec file to that, When user update the spec file.

### 3. Read & Search Spec Files
- Support retrieval of content:
  - Feature-specific specs: `.codeartsdoer/specs/{{feature-name}}/spec.md`
- Use `Grep` to search for specific requirements, scenarios, or keywords across spec files
- Use `Read` to load full spec content for review or modification
- Return search/reading results in a structured format (e.g., section headers + matching content snippets)

## Critical Constraints: Spec vs. Design
### Spec Defines "What to Build" (Allowed Content)
- System's external business behavior (user-facing functionality)
- Business rules, validation logic, and constraints
- User scenarios, acceptance criteria, and success/failure conditions
- Perspectives from product managers, testers, and business stakeholders
- Requirements using OpenSpec conventions (SHALL/MUST keywords, Scenario blocks)

### Strictly Prohibited Content (Design Details)
Do **not** include any of the following in spec.md files:
1. Database schema (tables, columns, data types, indexes)
2. Technical architecture (class diagrams, interface inheritance, function signatures)
3. Infrastructure decisions (caching strategies, message queues, middleware)
4. Implementation details (algorithms, performance optimizations, code structure)
5. Any content that answers "how to build" instead of "what to build"

## Execution Guidelines
1. Always validate file paths before creating/updating/deleting (use `Glob` to confirm directory structure)
2. Preserve OpenSpec formatting in all spec files (requirement headers, scenario blocks, delta markers)
3. Prompt the user for confirmation before:
   - Merging feature-specific changes to the root spec
   - Deleting feature-specific spec directories
4. Log all actions (create/update/merge/delete) with timestamps for auditability

## Next Steps
- For advanced `spec.md` template usage, see spec_template.md.

## Reference
`spec_template.md` is shown as follows:
```markdown
# **1. 组件定位**

**写作指导**

本章节目的是在短时间内让读者理解这个组件是什么、边界在哪里。

常见错误：

1\. 写成空泛的愿景描述

2\. 抄袭系统设计文档的内容

3\. 边界不清晰，什么都想做

写作原则：

1\. 核心职责用一句话说清楚，不超过50字

2\. 输入输出必须具体到数据对象级别

3\. 职责边界必须明确写出\"不做什么\"

## **1.1 核心职责**

用一句话描述本组件在系统中承担的核心业务能力。
格式建议：本组件负责 \[动作\] \[业务对象\]，实现 \[核心价值\]。

## **1.2 核心输入**

列出本组件接收的所有外部输入，包括：

1\. 上游系统的调用请求

2\. 用户的操作指令

3\. 定时任务的触发信号

4\. 消息队列的订阅消息

每条输入需说明来源和内容概要。

## **1.3 核心输出**

列出本组件对外产生的所有输出，包括：

1\. 返回给调用方的响应

2\. 发送给下游系统的请求

3\. 推送给用户的通知

4\. 发布到消息队列的事件

每条输出需说明目标和内容概要。

## **1.4 职责边界**

明确列出本组件不负责的事项。
这是防止职责蔓延的关键章节。

写作原则：

1\. 列出容易产生误解的边界地带

2\. 列出已经明确划给其他组件的职责

3\. 列出曾经讨论过但决定不做的功能

# **2. 领域术语**

**写作指导**

本章节目的是建立业务与代码共用的统一语言。

收录标准：

1\. 在代码中作为类名、变量名、枚举值出现的业务概念

2\. 在需求讨论中容易产生歧义的术语

3\. 有特定业务含义，不同于日常理解的词汇

格式要求：

1\. 使用定义列表格式，术语加粗

2\. 定义必须是完整的陈述句

3\. 备注为可选项，用于补充别名、反义词、易混淆项

**术语名称**
: 术语的业务定义，必须是完整的陈述句。

**术语名称**
: 术语的业务定义。
: 备注：可选的补充说明，如别名、易混淆项。

# **3. 角色与边界**

**写作指导**

本章节目的是明确谁会与本组件交互。

角色分类：

1\. 人类角色：直接操作系统的用户类型

2\. 外部系统：与本组件有接口调用关系的其他系统或组件

写作原则：

1\. 每个角色必须有明确的职责描述

2\. 上下文图必须使用 PlantUML 绘制

3\. 上下文图只展示组件与外部的交互，不展示内部结构

## **3.1 核心角色**

列出所有与本组件直接交互的人类角色。
格式：角色名 + 冒号 + 职责描述

## **3.2 外部系统**

列出所有与本组件有接口调用关系的外部系统。
包括上游调用方和下游依赖方。
格式：系统名 + 冒号 + 交互内容描述

## **3.3 交互上下文**

使用 PlantUML 绘制系统上下文图。

图中必须包含：

1\. 本组件（居中）

2\. 所有人类角色

3\. 所有外部系统

4\. 交互方向和交互内容的简要标注

图中禁止包含：

1\. 组件内部的模块划分

2\. 数据库、缓存等技术组件

3\. 详细的接口参数

# **4. DFX约束**

**写作指导**

本章节目的是前置定义非功能性红线。

DFX 约束会直接影响业务规则的设计，因此必须放在核心能力之前。

写作原则：

1\. 每条约束必须是可量化、可验证的

2\. 避免使用\"尽量\"\"适当\"等模糊词汇

3\. 如无明确要求，可标注\"待定\"，但不可留空

## **4.1 性能**

定义响应时间、吞吐量、资源占用等性能红线。

常见指标：

1\. 核心接口响应时间上限

2\. 系统吞吐量下限

3\. 单实例资源占用上限

## **4.2 可靠性**

定义可用性、故障恢复、数据一致性等可靠性要求。

常见指标：

1\. 系统可用性目标

2\. 故障恢复时间上限

3\. 数据一致性级别

## **4.3 安全性**

定义认证鉴权、数据加密、审计日志等安全要求。

常见要求：

1\. 接口认证方式

2\. 敏感数据加密要求

3\. 关键操作审计要求

## **4.4 可维护性**

定义监控告警、日志规范等运维支撑要求。

常见要求：

1\. 必须接入的监控指标

2\. 日志格式与内容规范

3\. 链路追踪要求

## **4.5 兼容性**

定义接口兼容、数据迁移等兼容性要求。

常见要求：

1\. 接口变更的兼容策略

2\. 存量数据的迁移要求

# **5. 核心能力**

**写作指导**

本章节是文档的主体，描述组件对外提供的所有业务能力。

组织原则：

1\. 按业务功能模块划分二级标题

2\. 每个模块包含三个固定子章节：业务规则、交互流程、异常场景

3\. 模块划分应与用户心智模型对齐，而非与代码结构对齐

严禁出现：

1\. 代码实现细节

2\. 数据库操作描述

3\. 内部函数调用链

## **5.1 \[功能模块名称\]**

模块名称应使用业务语言，如\"订单创建\"\"退款处理\"\"库存扣减\"。
避免使用技术语言，如\"写入模块\"\"查询模块\"。

### **5.1.1 业务规则**

**写作指导**

业务规则是本模块的核心内容。

规则分类：

1\. 数据校验规则：输入数据的合法性约束

2\. 状态流转规则：业务对象的生命周期变化

3\. 权限控制规则：谁可以执行什么操作

4\. 计算规则：金额、数量等业务计算逻辑

5\. 禁止项：明确不允许的操作

格式要求：

1\. 每条规则必须使用\"必须\"\"应当\"\"禁止\"等规范用语

2\. 每条规则必须附带验收条件

3\. 验收条件格式：触发场景 → 预期行为

1\. **规则名称**：规则的完整描述

a\. 验收条件：\[触发场景\] → \[预期行为\]

2\. **规则名称**：规则的完整描述

a\. 验收条件：\[触发场景\] → \[预期行为\]

3\. **禁止项**：禁止行为的完整描述

a\. 验收条件：\[触发场景\] → \[预期行为\]

### **5.1.2 交互流程**

**写作指导**

使用 PlantUML 时序图描述本模块的主干交互流程。

图中允许出现：

1\. 外部角色

2\. 本组件（作为一个整体）

3\. 外部系统

图中禁止出现：

1\. 本组件内部的类或模块

2\. 数据库、缓存等技术组件

3\. 具体的字段名和参数结构

图中应体现：

1\. 请求的发起方和接收方

2\. 主要的交互步骤

3\. 返回结果的方向

### **5.1.3 异常场景**

**写作指导**

列出本模块所有需要特殊处理的异常情况。

异常分类：

1\. 输入校验失败

2\. 业务规则冲突

3\. 外部系统调用失败

4\. 并发竞争冲突

5\. 超时与重试场景

格式要求：

1\. 触发条件：描述异常发生的前置条件

2\. 系统行为：描述组件内部的处理逻辑

3\. 用户感知：描述最终返回给用户的错误码或提示

1\. **异常场景名称**

a\. 触发条件：\[描述\]

b\. 系统行为：\[描述\]

c\. 用户感知：\[错误码或提示\]

2\. **异常场景名称**

a\. 触发条件：\[描述\]

b\. 系统行为：\[描述\]

c\. 用户感知：\[错误码或提示\]

## **5.2 \[功能模块名称\]**

按照 5.1 的结构继续编写其他功能模块。

# **6. 数据约束**

**写作指导**

本章节定义核心领域对象的逻辑约束。

**属于本章节的内容（逻辑约束）**

1\. 字段的业务含义

2\. 字段的取值范围

3\. 字段的格式要求

4\. 字段之间的业务关联

5\. 字段的唯一性、必填性要求

**不属于本章节的内容（实现细节）**

1\. 数据库字段类型

2\. 字段的存储方式

3\. 索引设计

4\. 表之间的外键关系

格式要求：

1\. 按领域对象划分二级标题

2\. 每个字段用列表项描述

3\. 字段名加粗，后接冒号和约束描述

## **6.1 领域对象名称**

领域对象应与领域术语章节中定义的术语对应。
每个字段的约束必须是可验证的。

1\. **字段名**：约束描述

2\. **字段名**：约束描述

3\. **字段名**：约束描述

## **6.2 领域对象名称**

1\. **字段名**：约束描述

2\. **字段名**：约束描述

```


ears-format.md is shown as follows:
```markdown
# EARS Format Guidelines

## Overview
EARS (Easy Approach to Requirements Syntax) is the standard format for acceptance criteria in spec-driven development.

EARS patterns describe the logical structure of a requirement (condition + subject + response) and are not tied to any particular natural language.  
All acceptance criteria should be written in the target language configured for the specification (for example, `spec.json.language` / `{{LANG_CODE}}`).  
Keep EARS trigger keywords and fixed phrases in English (`When`, `If`, `While`, `Where`, `The system shall`, `The [system] shall`) and localize only the variable parts (`[event]`, `[precondition]`, `[trigger]`, `[feature is included]`, `[response/action]`) into the target language. Do not interleave target-language text inside the trigger or fixed English phrases themselves.

## Primary EARS Patterns

### 1. Event-Driven Requirements
- **Pattern**: When [event], the [system] shall [response/action]
- **Use Case**: Responses to specific events or triggers
- **Example**: When user clicks checkout button, the Checkout Service shall validate cart contents

### 2. State-Driven Requirements
- **Pattern**: While [precondition], the [system] shall [response/action]
- **Use Case**: Behavior dependent on system state or preconditions
- **Example**: While payment is processing, the Checkout Service shall display loading indicator

### 3. Unwanted Behavior Requirements
- **Pattern**: If [trigger], the [system] shall [response/action]
- **Use Case**: System response to errors, failures, or undesired situations
- **Example**: If invalid credit card number is entered, then the website shall display error message

### 4. Optional Feature Requirements
- **Pattern**: Where [feature is included], the [system] shall [response/action]
- **Use Case**: Requirements for optional or conditional features
- **Example**: Where the car has a sunroof, the car shall have a sunroof control panel

### 5. Ubiquitous Requirements
- **Pattern**: The [system] shall [response/action]
- **Use Case**: Always-active requirements and fundamental system properties
- **Example**: The mobile phone shall have a mass of less than 100 grams

## Combined Patterns
- While [precondition], when [event], the [system] shall [response/action]
- When [event] and [additional condition], the [system] shall [response/action]

## Subject Selection Guidelines
- **Software Projects**: Use concrete system/service name (e.g., "Checkout Service", "User Auth Module")
- **Process/Workflow**: Use responsible team/role (e.g., "Support Team", "Review Process")
- **Non-Software**: Use appropriate subject (e.g., "Marketing Campaign", "Documentation")

## Quality Criteria
- Requirements must be testable, verifiable, and describe a single behavior.
- Use objective language: "shall" for mandatory behavior, "should" for recommendations; avoid ambiguous terms.
- Follow EARS syntax: [condition], the [system] shall [response/action].
```